<?php $__env->startSection('content'); ?>
    
    <?php if($data): ?>
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                
                <h4 class="ui dividing header teal centered">EDITAR DATOS DE PRODUCTO</h4>
                <br>

                <form class="ui form" id="frmEditar" autocomplete="off">
                    <input type="hidden" id="id_producto" name="id_producto" value="<?php echo e($data->id_producto); ?>">
                    
                    <div class="field">
                        <div class="field">
                            <label>Nombre del producto</label>
                            <div class="ui small input ">
                              <input type="text" name="nombre" maxlength="800" oninput="$.upperCase(this)" value="<?php echo e($data->nombre); ?>">
                            </div>
                        </div>
                    </div>                 
    
                    <div class="two fields">
                        <div class="field">
                            <label>Marca del producto</label>
                            <div class="ui small input ">
                              <input type="text" name="descripcion"  maxlength="200" oninput="$.upperCase(this)" value="<?php echo e($data->descripcion); ?>">
                            </div>
                        </div>
                        <div class="field">
                            <label>Código de Barras</label>
                            <div class="ui small input ">
                              <input type="text" name="codigo_barras"  maxlength="100" oninput="$.upperCase(this)" value="<?php echo e($data->codigo_barras); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="two fields">


                        
                        <div class="one wide field">
                            <label>&nbsp;</label>
                            <div class="ui small input">
                                <select class="ui fluid small input dropdown" name="tipo_precio">
                                    <option value="1"> S/ </option>
                                    <option value="2"> %  </option>
                                </select> 
                            </div>  
                        </div>

                        <div class="three wide field">
                            <label>Precio de VENTA Unitario</label>
                            <div class="ui small input">
                                <input type="text" name="precio" value="<?php echo e($data->precio); ?>" maxlength="11">
                            </div>  
                        </div>

                       

                        <div class="four wide field">
                            <label>Precio de Compra Unitario</label>
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" name="precio_compra" value="<?php echo e($data->precio_compra); ?>" maxlength="11">
                            </div>  
                        </div>


                        <div class="one wide field">
                            <label>Precio</label>
                            <div class="ui small input">
                                <select class="ui fluid small input dropdown" name="tipo_precio_2">
                                    <option value="1"> S/ </option>
                                    <option value="2"> %  </option>
                                </select> 
                            </div>  
                        </div>

                         <div class="three wide field">
                            <label>de venta por MAYOR</label>
                            <div class="ui small input">
                               
                                <input type="text" name="precio_mayorista" value="<?php echo e($data->precio_mayorista); ?>" maxlength="11">
                            </div>  
                        </div>

                        <div class="four wide field">
                            <label>Fecha de Vencimiento</label>
                            <div class="ui small input">
                                <input type="text" class="fecha" name="fecha_vencimiento" value="<?php echo e($data->fecha_vencimiento); ?>">
                            </div>  
                        </div>
                    </div> 

                    <div class="two fields">
                        <div class="field">
                            <label>Tipo de Presentación</label>
                            <select class="ui small search selection dropdown" name="id_tipo_presentacion">
                                <?php $__currentLoopData = $tipo_presentacion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($tipo->id_tipo_presentacion == $data->id_tipo_presentacion): ?>
                                        <option value="<?php echo e($tipo->id_tipo_presentacion); ?>" selected> <?php echo e($tipo->nombre); ?> </option>
                                    <?php else: ?>
                                        <option value="<?php echo e($tipo->id_tipo_presentacion); ?>"> <?php echo e($tipo->nombre); ?> </option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>  
                        </div>
                        <div class="field">
                            <label>Unidad de Medida</label>
                            <select class="ui small search selection dropdown" name="id_unidad_medida">
                                <?php $__currentLoopData = $unidad_medida; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($unidad->id_unidad_medida == $data->id_unidad_medida): ?>
                                        <option value="<?php echo e($unidad->id_unidad_medida); ?>" selected><?php echo e($unidad->nombre); ?> (<?php echo e($unidad->abreviatura); ?>)</option>
                                    <?php else: ?>
                                        <option value="<?php echo e($unidad->id_unidad_medida); ?>"><?php echo e($unidad->nombre); ?> (<?php echo e($unidad->abreviatura); ?>)</option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>  
                        </div>
                    </div>

                    <div class="two fields">
                        <div class="field">
                            <label>Situacion de Impuesto</label>
                            <select class="ui small selection dropdown" name="situacion_impuesto">
                                <option value="AFECTO" <?php echo e($data->situacion_impuesto == "AFECTO" ? "selected" : ""); ?>>Afecto</option>
                                <option value="INAFECTO" <?php echo e($data->situacion_impuesto == "INAFECTO" ? "selected" : ""); ?>>Inafecto</option>
                                <option value="EXONERADO" <?php echo e($data->situacion_impuesto == "EXONERADO" ? "selected" : ""); ?>>Exonerado</option>
                            </select>  
                        </div>
                        
                        <div class="field">
                            <label>Tipo de Producto</label>
                            <select class="ui small input dropdown" name="tipo_producto">
                                <option value="Generico" <?php echo e($data->tipo_producto == "Generico" ? "selected" : ""); ?>>Generico</option>
                                <option value="Comercial" <?php echo e($data->tipo_producto == "Comercial" ? "selected" : ""); ?>>Comercial</option>
                            </select>  
                        </div>

                    </div> 

                    <div class="two fields">
                         <div class=" field">
                            <label>Tipo de Impuesto</label>
                            <select class="ui small selection dropdown" name="tipo_impuesto">
                                <option value="IGV">IGV</option>
                                
                            </select>  
                        </div>
                        <div class="field">
                            <label>Valor de Impuesto</label>
                            <div class="ui right labeled small input">
                                <input type="text" name="valor_impuesto" value="<?php echo e($data->valor_impuesto); ?>" readonly maxlength="8">
                                <label class="ui label">%</label>
                            </div>  
                        </div>
                    </div>

                    <div class="two fields">

                        <?php if(Auth::guard("usuario")->user()->id_rol == 1 || Auth::guard("usuario")->user()->id_rol == 4): ?>


                        <div class="four wide field">
                            <label>Stock Actual</label>
                            <div class="ui small input">
                                <input type="text" name="cantidad" value="<?php echo e($cantidad ? ($cantidad->stock > 1000000 ? $cantidad->stock - 1000000 : 0) : 0); ?>" maxlength="50">
                            </div>  
                        </div>

                        <div class="four wide field">
                            <label>Cantidad para Alertas</label>
                            <div class="ui small input">
                                <input type="text" name="alerta" value="<?php echo e($cantidad ? $cantidad->stock_alerta : 0); ?>" maxlength="5">
                            </div>  
                        </div>
                        <?php else: ?>
                            <input type="hidden" name="cantidad" value="<?php echo e($cantidad ? ($cantidad->stock > 1000000 ? $cantidad->stock - 1000000 : 0) : 0); ?>" >
                            <input type="hidden" name="alerta" value="<?php echo e($cantidad ? $cantidad->stock_alerta : 0); ?>" >
                        <?php endif; ?>
                        
                        <div class=" field">
                            <label>Lote / Serie</label>
                            <div class="ui small input">
                                <input type="text" name="lote" value="<?php echo e($data->lote); ?>" maxlength="800">
                            </div>  
                        </div>
                    </div>  
                    
                    <div class="two fields">


                        <div class="six wide field">
                            <label>Imagen del producto</label>
                            <div class="ui action small input" id="cargar-imagen">
                                <input type="text" placeholder="Tamaño maximo de imagen 2MB" readonly>
                                <input type="file" name="imagen" id="imagen" multiple="" accept="image/x-png,image/gif,image/jpeg"/>
                              
                                <div class="ui icon button" title="Seleccione una imagen para el producto">
                                    <i class="attach icon"></i>
                                </div>
                            </div>  
                        </div>
                        
                        <div class="two wide field">
                            <label>&nbsp;</label>
                            <div class="ui fluid small green button btn_ver_imagen" title="Clic para ver lista de productos"><i class="search icon"></i>Ver Foto</div>
                        </div>

                        <div class=" field">
                            <label>Tiene ICBPER? (solo bolsas)</label>
                            <select class="ui small input dropdown" name="icbper">
                                <option value="0" <?php echo e($data->icbper == "0" ? "selected" : ""); ?>>NO</option>
                                <option value="1" <?php echo e($data->icbper == "1" ? "selected" : ""); ?>>SI</option>
                            </select> 
                        </div>
                    </div> 
              
                        
                    <div class="form_footer">
                        <a class="ui left floated default button" href="<?php echo e(URL::previous()); ?>"><i class="arrow left icon"></i>REGRESAR</a>
                        <div class="ui right floated primary button btn_guardar"><i class="save icon"></i>GUARDAR</div>
                    </div>    
                </form>

            </div>
        </div>

        <!--start update modal -->
        <div class="ui small basic modal" id="update_modal">
            <div class="ui icon header"><i class="paper plane icon"></i>Guardar cambios</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>¿Está seguro que quiere guardar los cambios que hizo?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para guardar cambios"> <i class="checkmark icon"></i>Guardar</div>
            </div>
        </div>
        <!--end update modal -->

        <!--start imagen modal -->
        <div class="ui standard mini modal" id="imagen_modal">
            <div class="header">Imagen del producto</div>
            <div class="scrolling content" >
                <img class="medium ui image" style="height: 300px; margin:auto;" id="img_producto" src="  <?php echo e($data->url_imagen != null ? asset('img/productos/'.$data->url_imagen) : asset('img/productos/default.jpg')); ?>">
            </div>
            <div class="actions" >
                <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div> 
            </div>
        </div>
        <!--end imagen modal -->


    <?php else: ?>
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                <h3 class="ui header black centered">No se encuentra el registro que desea editar</h3>
            </div>
        </div>    
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/producto/editar.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>