$(function () {

	/******************************************************************************/
	/* start: valida formulario de ventas
	/******************************************************************************/

    $('#frmNuevo').form({
      keyboardShortcuts: false,
    	fields: {
		    id_local: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },

		    motivo_retiro: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },

		    monto_perdido: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
		    cantidad_retiro: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
    	},
    	inline : true,
	});

  	$('.btn_registrar').on('click', function() {
  		
        if ($('#id_producto').val() !== "") {
            if ($('#frmNuevo').form('is valid')) {
                $('#register_modal').modal({
                    closable: false,
                    onApprove : function() {
                        sendForm();
                    }
                }).modal('show');  
            } else {
                $('#frmNuevo').form('validate form');
            }
        } else {
            swal("Seleccione", "algun producto para retirar", "warning");
        }

  	});	

  	function sendForm() {

	    var data = $('#frmNuevo').serialize();
	 	
        $.requestApi('/retiro/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve, true, APP_URL+'/retiro/detalles/'+resolve.id_retiro);
	        }
	    });
  
        return false;
	};
    

	/*********************************************************************************************************/
	/* start: calcula precios al presionar tecla
	/*********************************************************************************************************/
  	$('#cantidad_retiro').on('keyup', function(){
        validaStock(); 	
        if ($('#cantidad_retiro').val() == '0') {
        	$('#cantidad_retiro').val('1');
        }    
    });


  	/*********************************************************************************************************/
	/* modal mostrar todos los productos
	/*********************************************************************************************************/  	

    function buscarNombreProducto(producto) {
  
        $._requestApi('/producto_local/getByNombre', {'search' : producto }, 'GET', function (resolve) {
          if (resolve) {
            var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderProductos(resolve[i]));
                    }
                }
                $('#tbody_productos').html(datos.join(''));
            $("#btn_buscar_prod").removeClass('loading');
        }
      });
    };

	$('.btn_buscar_producto').on('click', function() {
  		$('#buscar_producto_modal').modal('show'); 
  		$('#buscar_producto').val('');
  		//resetearTablaProducto();
  	});	


	$('#buscar_producto').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	$("#btn_buscar_prod").addClass('loading');
	    	var producto = $('#buscar_producto').val();
    		buscarNombreProducto(producto);
    	}	
	});

	$('#btn_buscar_prod').on('click', function() {
		$("#btn_buscar_prod").addClass('loading');
    	var producto = $('#buscar_producto').val();
    	buscarNombreProducto(producto);
  	});


    $('body').on('click', '.btn_seleccionar_producto', function(){ 
    	
		$('#id_producto').val($(this).data('id'));
        $('#precio_venta').val($(this).data('precio'));
        $('#monto_perdido').val($(this).data('precio'));
        $('#stock').val($(this).data('stock'));  
        $('#nombre_producto').val($(this).data('nombre'));  

        $('#buscar_producto_modal').modal('hide'); 

  	});


});

/*********************************************************************************************************/
/* funciones de calculo
/*********************************************************************************************************/

function calculaMontoPerdido() {
	var monto = (parseFloat($('#precio_venta').val()).toFixed(2)*parseFloat($('#cantidad_retiro').val()).toFixed(2));
	$('#monto_perdido').val(validaNumero($('#precio_venta').val()) && validaNumero($('#cantidad_retiro').val()) ? monto.toFixed(2) : '');
}

function validaNumero(valor) {
    var expresion=/^[0-9]+([\.]{1}[0-9]+)?$/;
    return !expresion.test(valor) ? false : true; 
}

function validaStock() {
    if (parseFloat($('#cantidad_retiro').val()) > parseFloat($('#stock').val())) {
    	$('#cantidad_retiro').val(Math.round($('#stock').val()));
    }
}

/*********************************************************************************************************/
/* funciones de busqueda de productos
/*********************************************************************************************************/


function renderProductos(resolve){
  var arr = [];
    arr = [
        '<tr data-table="'+resolve.id_producto+'">',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.producto.codigo_barras,'</td>',
            '<td>',resolve.producto.nombre,' ',resolve.producto.descripcion,'</td>',
            '<td>',resolve.producto.tipo_presentacion.nombre,'</td>',
            '<td>',resolve.producto.unidad_medida.nombre,'</td>',
            '<td>',resolve.producto.precio,'</td>',
            '<td>', (resolve.producto.fecha_vencimiento !== '' ? resolve.producto.fecha_vencimiento : "Sin fecha") ,'</td>',
            '<td><div class="ui mini vertical animated positive button btn_seleccionar_producto" title="Seleccionar este producto" data-id="',resolve.id_producto,'" data-stock="',resolve.stock,'" data-precio="',resolve.producto.precio,'" data-nombre="',resolve.producto.nombre,'"><div class="hidden content">Elegir</div><div class="visible content"><i class="check icon"></i></div></div></td>',
        '</tr>',
    ];
    return arr.join(''); 
}