<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleDeliveryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_delivery', function (Blueprint $table) {
            $table->integer('id_detalle_delivery')->autoIncrement();
            $table->integer('id_delivery');
            $table->integer('id_producto');
            $table->decimal('cantidad', 15, 6);
            $table->decimal('precio', 15, 6);
            $table->decimal('descuento', 9, 2);
            $table->decimal('subtotal', 9, 2);
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();
            
            $table->foreign('id_delivery')
                  ->references('id_delivery')->on('delivery')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

            $table->foreign('id_producto')->references('id_producto')->on('productos'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_delivery');
    }
}
